# Include file for GURPS martial arts

$$macro maname(name,cin) {{$$ifdef(cin)$(name) (cinematic)$$else$(name)$$endif}}

$$macro martstyle(name, cost, primary, secondary, optional, maneuvers, cinskills, cinmaneuvers, req, cat)
{{
$$macrodesc("Martial Arts Style.")
$$argdesc(name, "Name of the style")
$$argdesc(cost, "Point cost of standard style")
$$argdesc(primary: autoitems, "Primary skills")
$$argdesc(secondary: autoitems, "Secondary skills")
$$argdesc(optional, "Optional skills: comma-separated list of optional skills")
$$argdesc(maneuvers: autoitems, "Maneuvers")
$$argdesc(cinskills: autoitems, "Cinematic skills (optional)")
$$argdesc(cinmaneuvers: autoitems, "Cinematic maneuvers (optional)")
$$argdesc(req: req, "Requirements (optional)")
$$argdesc(cat: cat, "Additional categories (optional)")

	$$if(cinskills = '' and cinmaneuvers = '')
		$$define cin 
	$$else
		$$define cin Cinematic 
	$$endif

	item "$$maname($(name),$(cin))"
	$$ifdef(PLUGIN) dsid "$(PLUGIN)" $$endif

	prereq "$mavalue('Primary Skill',\"$$maname($(name),$(cin))\",'max')-mavalue('Primary Skill',\"$$maname($(name),$(cin))\",'min')<=2::Difference in Primary skills must be 2 or less.$$ifdef(req)~$(req)$$endif"

	cat "Martial Arts Style;*Note$$ifdef(cat);$(cat)$$endif"

	level 0
	formula "0*skills"
	varname "Style$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"

	format "%0ln [^x|`Actual Cost`>=`Style Cost`?`Actual Cost`:format('%d of %d', `Actual Cost`, `Style Cost`)|]"
	altformat "Categories" "" "%0ln: ^t [^x|`Actual Cost`>=`Style Cost`?`Actual Cost`:format('%d of %d', `Actual Cost`, `Style Cost`)|]"
	sformat "%0ln%-10r!($(cost))"
	autochargecost dontmarkauto deleteauto noautodup
	script "MACheck();"

autoitems "?dupopt:Style=\"$$maname($(name),$(cin))\";?dupopt:Primary Skill=\"$$maname($(name),$(cin))\";?selexp:integer(optValue('TL Range'))<=tl;?opt:Minimum Cost=1;$(primary)\
$$ifdef(secondary);?clear;?dupopt:Style=\"$$maname($(name),$(cin))\";?selexp:integer(optValue('TL Range'))<=tl;?default;?dupopt:Secondary Skill=\"$$maname($(name),$(cin))\";$(secondary)$$endif\
$$ifdef(optional);?clear;?dupopt:Style=\"$$maname($(name),$(cin))\";?selexp:integer(optValue('TL Range'))<=tl;?dupopt:Optional Skill=\"$$maname($(name),$(cin))\";?default;?uchoose:Optional Skills,$(optional)$$endif\
$$ifdef(cinskills);?clear;Sublist[Cinematic Skills: $(name)];?open;?dupopt:Style=\"$$maname($(name),$(cin))\";?dupopt:Cinematic Skill=\"$$maname($(name),$(cin))\";$(cinskills);?close$$endif\
$$if(maneuvers <> '' or cinmaneuvers <> '');?clear;Sublist[Maneuvers: $(name)];?open$$endif\
$$ifdef(maneuvers);?clear;?dupopt:Style=\"$$maname($(name),$(cin))\";?dupopt:Style Maneuver;$(maneuvers)$$endif\
$$ifdef(cinmaneuvers);?clear;?dupopt:Style=\"$$maname($(name),$(cin))\";?dupopt:Style Maneuver;$(cinmaneuvers)$$endif\
$$if(maneuvers <> '' or cinmaneuvers <> '');?close$$endif"

	editdlg 2

	opt
		begin text "Style Cost" "$(cost)" noprint end
		begin exp "Actual Cost" "totalItems('Skills:@Style=itemInfo(\"@!n@\")',0,1,'cost')" noprint end
		end
}}



# Martials Arts style macro.
# name: name of style
# cost: cost in character points. If normal and cinematic costs, separate by "/": "9/12"
# primary: list of primary skills separated by semicolons
# secondary: list of secondary skills separated by semicolons.
# maneuvers: list of maneuvers separated by semicolons.
# cinskills: list of cinematic skills separated by semicolons.
# cinmaneuvers: list of cinematic maneuvers separated by semicolons.

$$macro style(name, cost, primary, secondary, optional, maneuvers, cinskills, cinmaneuvers, req, cat)
{{
$$macrodesc("Martial Arts Style. Creates standard and cinematic style if second cost specified after /.")
$$argdesc(name, "Name of the style")
$$argdesc(cost, "Point cost of standard style/cinematic style (optional)")
$$argdesc(primary: autoitems, "Primary skills")
$$argdesc(secondary: autoitems, "Secondary skills")
$$argdesc(optional, "Optional skills. Semicolon delimited list of optional skills.")
$$argdesc(maneuvers: autoitems, "Maneuvers")
$$argdesc(cinskills: autoitems, "Cinematic skills (optional)")
$$argdesc(cinmaneuvers: autoitems, "Cinematic maneuvers (optional)")
$$argdesc(req: req, "Requirements (optional)")

	$$scan(cost, "^([0-9]+)/([0-9]+)$|^([0-9]+)$", ncost, ccost)
	$$martstyle($(name), $(ncost), $(primary), $(secondary), $(optional), $(maneuvers), , , $(req), $(cat))
	$$ifdef(ccost)
		$$martstyle($(name), $(ccost), $(primary), $(secondary), $(optional), $(maneuvers), $(cinskills), $(cinmaneuvers), $(req), $(cat))
	$$endif

}}


$$macro macombo(dummy)
{{
	$$item(Combination)
	dupexpected
	cat "Martial Arts Combination"
	format "%0ln: ^x|listOptions('optTextValue', 'Maneuver', '-')|%-14rc%-7r!"
	sformat "%0ln%-20r!2/maneuver"
	formula "optCount('Maneuver')*2"
	level 0
	checkexp "optCount('Maneuver')<=3"
	checkmsg "Only two or three maneuvers are allowed in a combination."
	editdlg 2
	opt
		begin text "Maneuver" "Choose" noprint keepold end
		begin text "Maneuver" "Choose" noprint keepold end
		end
}}
